/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.socket;

import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLSocketFactory {
    protected static SSLContext sslContext = null;
    protected static SocketFactory socketFactory = null;
    protected static ServerSocketFactory serverSocketFactory = null;

    protected static void buildSslContext() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        if (sslContext != null) {
            return;
        }
        KeyStore keyStore = KeyStore.getInstance("JKS");
        KeyStore trustStore = KeyStore.getInstance("JKS");
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = SSLSocketFactory.class.getResourceAsStream("server-keystore.jks");){
            keyStore.load(is, "uiz123".toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(trustStore);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keyStore, "uiz123".toCharArray());
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), trustAllCerts, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected static void buildSocketFactory() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        if (socketFactory != null) {
            return;
        }
        if (sslContext == null) {
            SSLSocketFactory.buildSslContext();
        }
        socketFactory = sslContext.getSocketFactory();
    }

    protected static void buildServerSocketFactory() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        if (serverSocketFactory != null) {
            return;
        }
        if (sslContext == null) {
            SSLSocketFactory.buildSslContext();
        }
        serverSocketFactory = sslContext.getServerSocketFactory();
    }

    public static synchronized Socket createConnection(String host, Integer port) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        if (socketFactory == null) {
            SSLSocketFactory.buildSocketFactory();
        }
        Socket s = socketFactory.createSocket(host, (int)port);
        return s;
    }

    public static synchronized ServerSocket createServerSocket(Integer port) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        if (serverSocketFactory == null) {
            SSLSocketFactory.buildServerSocketFactory();
        }
        ServerSocket serverSocket = serverSocketFactory.createServerSocket(port);
        return serverSocket;
    }
}

